'use strict';

/* --------------------------------------------------------------
 product_question.js 2016-11-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Widget that updates that opens a lightbox for asking product questions. Sends an e-mail to the shop administrator
 * with the asked question
 */
gambio.widgets.module('product_question', ['xhr', gambio.source + '/libs/modal.ext-magnific', gambio.source + '/libs/modal'], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        $body = $('body'),
        defaults = {
        btnOpen: '.btn-product-question',
        btnClose: '.btn-close-question-window',
        btnSend: '.btn-send-question',
        url: 'shop.php?do=ProductQuestion',
        sendUrl: 'shop.php?do=ProductQuestion/Send',
        productId: 0,
        formSelector: '#product-question-form',
        productFormSelector: '.js-product-form'
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    // ########## EVENT HANDLER ##########

    var _validateForm = function _validateForm() {
        try {
            var $privacyCheckbox = $('#privacy_accepted'),
                error = false;

            $this.find('.form-group.mandatory, .checkbox-inline').removeClass('has-error');

            // Validate required fields. 
            $this.find('.form-group.mandatory').each(function () {
                var $formControl = $(this).find('.form-control');

                if ($formControl.val() === '') {
                    $(this).addClass('has-error');
                    error = true;
                }
            });

            if ($privacyCheckbox.length && !$privacyCheckbox.prop('checked')) {
                $privacyCheckbox.closest('.checkbox-inline').addClass('has-error');
                error = true;
            }

            if (error) {
                throw new Error();
            }

            return true;
        } catch (exception) {
            return false;
        }
    };

    var _openModal = function _openModal() {
        var formData = $(options.productFormSelector).serialize();

        jse.libs.xhr.get({ url: options.url + '&' + formData + '&productId=' + options.productId }, true).done(function (response) {
            _closeModal();
            $body.append(response.content);
            gambio.widgets.init($('.mfp-wrap'));
            _activateGoogleRecaptcha();
        });
    };

    var _closeModal = function _closeModal() {
        $('.mfp-bg, .mfp-wrap').remove();
        $(options.btnSend).off('click', _sendForm);
        $(options.btnClose).off('click', _closeModal);
    };

    var _sendForm = function _sendForm() {
        if (!_validateForm()) {
            return;
        }

        var formData = $(options.productFormSelector).serialize();
        var url = options.sendUrl + '&' + formData + '&productId=' + options.productId,
            data = $(options.formSelector).serialize() + '&productLink=' + location.href;

        $.ajax({
            url: url,
            data: data,
            type: 'POST',
            dataType: 'json'
        }).done(function (response) {
            _closeModal();
            $body.append(response.content);
            gambio.widgets.init($('.mfp-wrap'));

            if (!response.success) {
                _activateGoogleRecaptcha();
            }
        });
    };

    var _activateGoogleRecaptcha = function _activateGoogleRecaptcha() {
        if (typeof window.showRecaptcha === 'function') {
            setTimeout(function () {
                window.showRecaptcha('captcha_wrapper');
            }, 500);
        }
    };

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     */
    module.init = function (done) {
        if (options.modalMode === undefined) {
            $(options.btnOpen).on('click', _openModal);
        }
        $(options.btnSend).on('click', _sendForm);
        $(options.btnClose).on('click', _closeModal);

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
